"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LiveTranscriptionEvents = void 0;
/**
 * Enumeration of events related to live transcription.
 *
 * - `Open`: Built-in socket event for when the connection is opened.
 * - `Close`: Built-in socket event for when the connection is closed.
 * - `Error`: Built-in socket event for when an error occurs.
 * - `Transcript`: Event for when a transcript message is received.
 * - `Metadata`: Event for when metadata is received.
 * - `UtteranceEnd`: Event for when an utterance ends.
 * - `SpeechStarted`: Event for when speech is detected.
 * - `Unhandled`: Catch-all event for any other message event.
 */
var LiveTranscriptionEvents;
(function (LiveTranscriptionEvents) {
    /**
     * Built in socket events.
     */
    LiveTranscriptionEvents["Open"] = "open";
    LiveTranscriptionEvents["Close"] = "close";
    LiveTranscriptionEvents["Error"] = "error";
    /**
     * Message { type: string }
     */
    LiveTranscriptionEvents["Transcript"] = "Results";
    LiveTranscriptionEvents["Metadata"] = "Metadata";
    LiveTranscriptionEvents["UtteranceEnd"] = "UtteranceEnd";
    LiveTranscriptionEvents["SpeechStarted"] = "SpeechStarted";
    /**
     * Catch all for any other message event
     */
    LiveTranscriptionEvents["Unhandled"] = "Unhandled";
})(LiveTranscriptionEvents = exports.LiveTranscriptionEvents || (exports.LiveTranscriptionEvents = {}));
//# sourceMappingURL=LiveTranscriptionEvents.js.map